/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.IVWWSParamExpressionCellEditorTableModel;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class VWInvokeWSOperationParameterTableModel
extends AbstractTableModel
implements IVWWSParamExpressionCellEditorTableModel {
    private static String ATTACH_BY_VALUE = null;
    private static String ATTACH_BY_VALUE_ARRAY = null;
    private static final String ARRAY = "[ ]";
    public static final int NUM_COLUMNS = 3;
    public static final int COL_NAME = 0;
    public static final int COL_TYPE = 1;
    public static final int COL_VALUE = 2;
    public static final int PARAM_TYPE_INCOMING = 0;
    public static final int PARAM_TYPE_OUTGOING = 1;
    private Vector m_rowData = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private int m_nMode = 0;

    public VWInvokeWSOperationParameterTableModel(VWAuthPropertyData authPropertyData, int nMode) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.m_nMode = nMode;
            ATTACH_BY_VALUE = VWResource.s_byValue.toString(VWFieldType.getLocalizedString(32));
            ATTACH_BY_VALUE_ARRAY = VWResource.s_byValue.toString(VWFieldType.getLocalizedString(32) + ARRAY);
            this.m_rowData = new Vector();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void reinitialize(VWWebServiceParameterDefinition[] paramDefs) {
        try {
            this.m_rowData.removeAllElements();
            if (paramDefs != null) {
                for (int i = 0; i < paramDefs.length; ++i) {
                    if (i < paramDefs.length - 1 && paramDefs[i].getLexicalLevel() < paramDefs[i + 1].getLexicalLevel()) continue;
                    this.m_rowData.addElement(paramDefs[i]);
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.s_nameStr;
            }
            case 1: {
                return VWResource.s_typeStr;
            }
            case 2: {
                if (this.m_nMode == 0) {
                    return VWResource.s_fieldNameStr;
                }
                return VWResource.s_expressionStr;
            }
        }
        return null;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWWebServiceParameterDefinition paramDef = this.getItemAt(nRowIndex);
            if (paramDef == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    return paramDef.getName();
                }
                case 1: {
                    return this.getTypeFromParam(paramDef);
                }
                case 2: {
                    return paramDef.getValue();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex) {
                case 2: {
                    this.onUpdateFieldValue(aValue, nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWWebServiceParameterDefinition getItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            return (VWWebServiceParameterDefinition)this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    public int getParameterType(int nRowIndex) {
        VWWebServiceParameterDefinition paramDef = this.getItemAt(nRowIndex);
        if (paramDef != null) {
            return paramDef.getDataType();
        }
        return -1;
    }

    public boolean getIsArray(int nRowIndex) {
        VWWebServiceParameterDefinition paramDef = this.getItemAt(nRowIndex);
        if (paramDef != null) {
            return paramDef.getIsArray();
        }
        return false;
    }

    public int getMode(int nRowIndex) {
        VWWebServiceParameterDefinition paramDef = this.getItemAt(nRowIndex);
        if (paramDef != null) {
            return paramDef.getMode();
        }
        if (this.m_nMode == 0) {
            return 2;
        }
        return 1;
    }

    private void onUpdateFieldValue(Object aValue, int nRowIndex) {
        try {
            if (aValue != null) {
                String expression = (String)aValue;
                VWWebServiceParameterDefinition paramDef = this.getItemAt(nRowIndex);
                if (paramDef != null) {
                    paramDef.setValue(expression);
                    this.m_authPropertyData.setDirty();
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private Object getTypeFromParam(VWWebServiceParameterDefinition paramDef) {
        try {
            if (paramDef != null) {
                if (paramDef.getDataType() == 32 && paramDef.isAttachmentByValue()) {
                    if (paramDef.getIsArray()) {
                        return ATTACH_BY_VALUE_ARRAY;
                    }
                    return ATTACH_BY_VALUE;
                }
                StringBuffer buffer = new StringBuffer(VWFieldType.getLocalizedString(paramDef.getDataType()));
                if (paramDef.getIsArray()) {
                    buffer.append(ARRAY);
                }
                return buffer.toString();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }
}

